<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddTahunToKelulusan extends Migration
{
    public function up()
    {
        // tambah kolom tahun kalau belum ada
        $fields = $this->db->getFieldNames('kelulusan');
        if (!in_array('tahun', $fields, true)) {
            $this->forge->addColumn('kelulusan', [
                'tahun' => [
                    'type'       => 'VARCHAR',
                    'constraint' => 9,   // contoh: 2025/2026
                    'after'      => 'id',
                ],
            ]);
        }
    }

    public function down()
    {
        // rollback: hapus kolom tahun
        $fields = $this->db->getFieldNames('kelulusan');
        if (in_array('tahun', $fields, true)) {
            $this->forge->dropColumn('kelulusan', 'tahun');
        }
    }
}
